<?php
class VisitasFAT {
    public $dti;
	public $dtf;
    public $cfat;
	public $primeiraVisita;
    public $ultimaVisita;
	public $totalEncontrado;
	public $visitas = array();
	public $ok;
	public $sql1;
	
	private $con;

    public function __construct($con, $cfat, $dti, $dtf, $cbos) {
		$this->totalEncontrado = 0;
		$this->ok = false;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->cfat = $cfat;
		$this->con = $con;

		$tcbos = "";
		if (count($cbos) > 0){
			$tcbos = "WHERE nu_cbo LIKE ANY (array[";
			foreach ($cbos as $v) {
				$tcbos .= "'".$v."%',";
			}
			$tcbos = substr($tcbos,0,-1);
			$tcbos .= "])";
		}

		$this->sql1 = "
			SELECT
				*
			FROM
			(
                SELECT
                    t5.*,
                    tb_dim_desfecho_visita.ds_desfecho_visita
                FROM
                (
                    SELECT
                        t4.*,
                        tb_dim_equipe.nu_ine,
                        tb_dim_equipe.no_equipe
                    FROM
                    (
                        SELECT
                            t3.*,
                            tb_dim_unidade_saude.nu_cnes, 
                            tb_dim_unidade_saude.no_unidade_saude
                        FROM
                        (
                            SELECT
                                t2.*,
                                tb_dim_cbo.nu_cbo, 
                                tb_dim_cbo.no_cbo
                            FROM
                            (
                                SELECT
                                    t1.*,
                                    tb_dim_profissional.nu_cns AS nu_cns_profissional,
                                    tb_dim_profissional.no_profissional
                                FROM
                                (
                                    SELECT 
                                        co_seq_fat_visita_domiciliar,  
                                        co_dim_profissional, 
                                        co_dim_cbo, 
                                        co_dim_unidade_saude, 
                                        co_dim_equipe, 
                                        co_dim_tempo, 
                                        nu_micro_area, 
                                        nu_cns, 
                                        co_dim_desfecho_visita,
                                        co_fat_cidadao_pec, 
                                        nu_cpf_cidadao, 
                                        nu_latitude, 
                                        nu_longitude
                                    FROM
                                        tb_fat_visita_domiciliar
                                    WHERE
                                        (co_fat_cidadao_pec = ".$cfat.") AND
                                        (co_dim_tempo >= ".$dti." AND co_dim_tempo <= ".$dtf.")
                                ) AS t1
                                LEFT JOIN
                                    tb_dim_profissional
                                ON tb_dim_profissional.co_seq_dim_profissional = t1.co_dim_profissional
                            ) AS t2
                            LEFT JOIN
                                tb_dim_cbo
                            ON tb_dim_cbo.co_seq_dim_cbo = t2.co_dim_cbo
                        ) AS t3
                        LEFT JOIN
                            tb_dim_unidade_saude
                        ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t3.co_dim_unidade_saude
                    ) AS t4
                    LEFT JOIN
                        tb_dim_equipe
                    ON tb_dim_equipe.co_seq_dim_equipe = t4.co_dim_equipe
                ) AS t5
                LEFT JOIN
                    tb_dim_desfecho_visita
                ON tb_dim_desfecho_visita.co_seq_dim_desfecho_visita = t5.co_dim_desfecho_visita
			) AS t6
			".$tcbos."
			ORDER BY co_dim_tempo
		";
    }
    public function todos() {
		$primeira = true;
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
			if($this->totalEncontrado > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					if ($primeira){
						$this->primeiraVisita = $rows->co_dim_tempo;
						$primeira = false;
					}
                    $this->visitas[$conta_array]['ordem'] = $rows->co_seq_fat_visita_domiciliar;
                    $this->visitas[$conta_array]['dtVisita'] = $rows->co_dim_tempo;
                    $this->visitas[$conta_array]['ma'] = $rows->nu_micro_area;
                    $this->visitas[$conta_array]['cns'] = $rows->nu_cns;
                    $this->visitas[$conta_array]['cidadao'] = $rows->co_fat_cidadao_pec;
                    $this->visitas[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
                    $this->visitas[$conta_array]['lati'] = $rows->nu_latitude;
                    $this->visitas[$conta_array]['long'] = $rows->nu_longitude;
                    $this->visitas[$conta_array]['cnsProfissional'] = $rows->nu_cns_profissional;
                    $this->visitas[$conta_array]['nomeProfissional'] = $rows->no_profissional;
                    $this->visitas[$conta_array]['cbo'] = $rows->nu_cbo;
                    $this->visitas[$conta_array]['ocupacao'] = $rows->no_cbo;
                    $this->visitas[$conta_array]['cnes'] = $rows->nu_cnes;
                    $this->visitas[$conta_array]['unidade'] = $rows->no_unidade_saude;
                    $this->visitas[$conta_array]['ine'] = $rows->nu_ine;
                    $this->visitas[$conta_array]['equipe'] = $rows->no_equipe;
                    $this->visitas[$conta_array]['desfVisita'] = $rows->ds_desfecho_visita;
					$conta_array++;
                    $this->ultimaVisita = $rows->co_dim_tempo;
				}
			}
		}
    }
    public function total() {
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
			if($this->totalEncontrado > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->primeiraVisita = $rows->co_dim_tempo;
					break;
				}
			}
		}
    }
}

class VisitasMA {
    public $dti;
	public $dtf;
    public $ma;
	public $primeiraVisita;
    public $ultimaVisita;
	public $totalEncontrado;
	public $visitas = array();
	public $ok;
	public $sql1;
    public $sql2;
    public $sql3;
	
	private $con;

    public $sql_function = "
        CREATE OR REPLACE FUNCTION retira_acentuacao(p_texto text)  
            RETURNS text AS  
            \$BODY$  
                select translate($1,  
                    'áàâãäåaaaÁÂÃÄÅAAAÀéèêëeeeeeEEEÉEEÈìíîïìiiiÌÍÎÏÌIIIóôõöoooòÒÓÔÕÖOOOùúûüuuuuÙÚÛÜUUUUçÇñÑýÝ',
                    'aaaaaaaaaAAAAAAAAAeeeeeeeeeEEEEEEEiiiiiiiiIIIIIIIIooooooooOOOOOOOOuuuuuuuuUUUUUUUUcCnNyY'  
                );  
            \$BODY$  
        LANGUAGE sql VOLATILE  
        COST 100; 
    ";

    public function __construct($con, $ma, $dti, $dtf, $cbos) {
		$this->totalEncontrado = 0;
		$this->ok = false;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->ma = $ma;
		$this->con = $con;

		$tcbos = "";
		if (count($cbos) > 0){
			$tcbos = "WHERE nu_cbo LIKE ANY (array[";
			foreach ($cbos as $v) {
				$tcbos .= "'".$v."%',";
			}
			$tcbos = substr($tcbos,0,-1);
			$tcbos .= "])";
		}

        $this->sql3 = "
            SELECT 
                translate(no_cidadao,'áàâãäåaaaÁÂÃÄÅAAAÀéèêëeeeeeEEEÉEEÈìíîïìiiiÌÍÎÏÌIIIóôõöoooòÒÓÔÕÖOOOùúûüuuuuÙÚÛÜUUUUçÇñÑýÝ','aaaaaaaaaAAAAAAAAAeeeeeeeeeEEEEEEEiiiiiiiiIIIIIIIIooooooooOOOOOOOOuuuuuuuuUUUUUUUUcCnNyY') AS no_cidadao,
                dt_nascimento,
                translate(no_mae,'áàâãäåaaaÁÂÃÄÅAAAÀéèêëeeeeeEEEÉEEÈìíîïìiiiÌÍÎÏÌIIIóôõöoooòÒÓÔÕÖOOOùúûüuuuuÙÚÛÜUUUUçÇñÑýÝ','aaaaaaaaaAAAAAAAAAeeeeeeeeeEEEEEEEiiiiiiiiIIIIIIIIooooooooOOOOOOOOuuuuuuuuUUUUUUUUcCnNyY') AS no_mae
            FROM 
                tb_cidadao 
            WHERE 
                nu_cns = ? OR nu_cpf = ?
            ORDER BY co_seq_cidadao DESC LIMIT 1
        ";
        $this->sql2 = "
            SELECT
                t2.*,
                tb_dim_municipio.no_municipio,
                tb_dim_municipio.co_ibge
            FROM
            (
                SELECT
                    tb_fat_cad_domiciliar.nu_latitude AS lat_endereco,
                    tb_fat_cad_domiciliar.nu_longitude AS lon_endereco,
                    tb_fat_cad_domiciliar.co_dim_municipio
                FROM 
                (
                    SELECT 
                        co_fat_cad_domiciliar 
                    FROM 
                        tb_fat_cad_dom_familia 
                    WHERE 
                        co_fat_cidadao_pec = ? 
                    ORDER BY co_seq_fat_cad_dom_familia DESC LIMIT 1
                ) AS t1
                JOIN tb_fat_cad_domiciliar
                ON tb_fat_cad_domiciliar.co_seq_fat_cad_domiciliar = t1.co_fat_cad_domiciliar
            ) AS t2
            JOIN tb_dim_municipio
            ON tb_dim_municipio.co_seq_dim_municipio = t2.co_dim_municipio
        ";
		$this->sql1 = "
			SELECT
				*
			FROM
			(
                SELECT
                    t5.*,
                    tb_dim_desfecho_visita.ds_desfecho_visita
                FROM
                (
                    SELECT
                        t4.*,
                        tb_dim_equipe.nu_ine,
                        tb_dim_equipe.no_equipe
                    FROM
                    (
                        SELECT
                            t3.*,
                            tb_dim_unidade_saude.nu_cnes, 
                            tb_dim_unidade_saude.no_unidade_saude
                        FROM
                        (
                            SELECT
                                t2.*,
                                tb_dim_cbo.nu_cbo, 
                                tb_dim_cbo.no_cbo
                            FROM
                            (
                                SELECT
                                    t1.*,
                                    tb_dim_profissional.nu_cns AS nu_cns_profissional,
                                    tb_dim_profissional.no_profissional
                                FROM
                                (
                                    SELECT 
                                        co_seq_fat_visita_domiciliar,  
                                        co_dim_profissional, 
                                        co_dim_cbo, 
                                        co_dim_unidade_saude, 
                                        co_dim_equipe, 
                                        co_dim_tempo, 
                                        nu_micro_area, 
                                        nu_cns, 
                                        co_dim_desfecho_visita,
                                        co_fat_cidadao_pec, 
                                        nu_cpf_cidadao, 
                                        nu_latitude, 
                                        nu_longitude
                                    FROM
                                        tb_fat_visita_domiciliar
                                    WHERE
                                        (nu_micro_area = '".$ma."') AND
                                        (co_dim_tempo >= ".$dti." AND co_dim_tempo <= ".$dtf.")
                                ) AS t1
                                LEFT JOIN
                                    tb_dim_profissional
                                ON tb_dim_profissional.co_seq_dim_profissional = t1.co_dim_profissional
                            ) AS t2
                            LEFT JOIN
                                tb_dim_cbo
                            ON tb_dim_cbo.co_seq_dim_cbo = t2.co_dim_cbo
                        ) AS t3
                        LEFT JOIN
                            tb_dim_unidade_saude
                        ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t3.co_dim_unidade_saude
                    ) AS t4
                    LEFT JOIN
                        tb_dim_equipe
                    ON tb_dim_equipe.co_seq_dim_equipe = t4.co_dim_equipe
                ) AS t5
                LEFT JOIN
                    tb_dim_desfecho_visita
                ON tb_dim_desfecho_visita.co_seq_dim_desfecho_visita = t5.co_dim_desfecho_visita
			) AS t6
			".$tcbos."
			ORDER BY co_dim_tempo
		";
    }
    public function todos() {
		$primeira = true;
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
			if($this->totalEncontrado > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					if ($primeira){
						$this->primeiraVisita = $rows->co_dim_tempo;
						$primeira = false;
					}
                    $this->visitas[$conta_array]['ordem'] = $rows->co_seq_fat_visita_domiciliar;
                    $this->visitas[$conta_array]['dtVisita'] = $rows->co_dim_tempo;
                    $this->visitas[$conta_array]['ma'] = $rows->nu_micro_area;
                    $this->visitas[$conta_array]['cns'] = $rows->nu_cns;
                    $this->visitas[$conta_array]['cidadao'] = $rows->co_fat_cidadao_pec;
                    $this->visitas[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
                    $this->visitas[$conta_array]['lati'] = $rows->nu_latitude;
                    $this->visitas[$conta_array]['long'] = $rows->nu_longitude;
                    $this->visitas[$conta_array]['cnsProfissional'] = $rows->nu_cns_profissional;
                    $this->visitas[$conta_array]['nomeProfissional'] = $rows->no_profissional;
                    $this->visitas[$conta_array]['cbo'] = $rows->nu_cbo;
                    $this->visitas[$conta_array]['ocupacao'] = $rows->no_cbo;
                    $this->visitas[$conta_array]['cnes'] = $rows->nu_cnes;
                    $this->visitas[$conta_array]['unidade'] = $rows->no_unidade_saude;
                    $this->visitas[$conta_array]['ine'] = $rows->nu_ine;
                    $this->visitas[$conta_array]['equipe'] = $rows->no_equipe;
                    $this->visitas[$conta_array]['desfVisita'] = $rows->ds_desfecho_visita;
                    $this->visitas[$conta_array]['lati_end'] = $rows->nu_latitude;
                    $this->visitas[$conta_array]['long_end'] = $rows->nu_longitude;
                    $this->visitas[$conta_array]['municipio'] = '';
                    $this->visitas[$conta_array]['nome'] = '';
                    $this->visitas[$conta_array]['dtNascimento'] = '';
                    $this->visitas[$conta_array]['mae'] = '';
                    $this->visitas[$conta_array]['uf'] = '';
                    $this->visitas[$conta_array]['bairro'] = '';
                    $this->visitas[$conta_array]['logradouro'] = '';
                    $this->visitas[$conta_array]['numero'] = '';
                    $this->visitas[$conta_array]['complemento'] = '';
                    $this->visitas[$conta_array]['tipoLogradouro'] = '';
                    $this->visitas[$conta_array]['cns_responsavel'] = '';
                    $this->visitas[$conta_array]['cpf_responsavel'] = '';
                    $rse = $this->con->prepare($this->sql2);
                    $rse->bindParam(1,$rows->co_fat_cidadao_pec);
                    if($rse->execute()){
                        if($rse->rowCount() > 0){
                            while($rowse = $rse->fetch(PDO::FETCH_OBJ)){
                                $this->visitas[$conta_array]['lati_end'] = $rowse->lat_endereco;
                                $this->visitas[$conta_array]['long_end'] = $rowse->lon_endereco;
                                $this->visitas[$conta_array]['municipio'] = $rowse->no_municipio;
                            }
                        }
                    }
                    $rsn = $this->con->prepare($this->sql3);
                    $rsn->bindParam(1,$rows->nu_cns);
                    $rsn->bindParam(2,$rows->nu_cpf_cidadao);
                    if($rsn->execute()){
                        if($rsn->rowCount() > 0){
                            while($rowsn = $rsn->fetch(PDO::FETCH_OBJ)){
                                $this->visitas[$conta_array]['dtNascimento'] = $rowsn->dt_nascimento;
                                if (extension_loaded('mbstring')) {
                                    $this->visitas[$conta_array]['nome'] = mb_strtoupper($rowsn->no_cidadao, 'UTF-8');
                                    $this->visitas[$conta_array]['mae'] = mb_strtoupper($rowsn->no_mae, 'UTF-8');
                                } else {
                                    $this->visitas[$conta_array]['nome'] = strtoupper($rowsn->no_cidadao);
                                    $this->visitas[$conta_array]['mae'] = strtoupper($rowsn->no_mae);
                                }
                            }
                        }
                    }
                    if (strlen($this->visitas[$conta_array]['nome']) > 0 && strlen($this->visitas[$conta_array]['dtNascimento']) > 0){
                        $query_mae = "";
                        if (strlen($this->visitas[$conta_array]['mae']) > 0){
                            $query_mae = "AND translate(no_mae_cidadao,'áàâãäåaaaÁÂÃÄÅAAAÀéèêëeeeeeEEEÉEEÈìíîïìiiiÌÍÎÏÌIIIóôõöoooòÒÓÔÕÖOOOùúûüuuuuÙÚÛÜUUUUçÇñÑýÝ','aaaaaaaaaAAAAAAAAAeeeeeeeeeEEEEEEEiiiiiiiiIIIIIIIIooooooooOOOOOOOOuuuuuuuuUUUUUUUUcCnNyY') LIKE '".$this->visitas[$conta_array]['mae']."%'";
                        }
                        $sql4 = "
                        SELECT
                            t4.nu_celular_cidadao,
                            t4.nu_cns_cidadao,
                            t4.nu_cpf_cidadao,
                            t4.nu_cartao_sus_responsavel,
                            t4.nu_cpf_responsavel,
                            t4.no_logradouro,
                            t4.nu_domicilio,
                            t4.ds_complemento,
                            t4.no_bairro,
                            t4.nu_cep,
                            t4.nu_micro_area,
                            t4.nu_latitude,
                            t4.nu_longitude,
                            t4.no_tipo_logradouro,
                            tb_uf.no_uf,
                            tb_uf.sg_uf
                        FROM
                        (
                            SELECT
                                t3.*,
                                tb_tipo_logradouro.no_tipo_logradouro
                            FROM
                            (
                                SELECT 
                                    t2.*,
                                    tb_cds_cad_domiciliar.no_logradouro,
                                    tb_cds_cad_domiciliar.nu_domicilio,
                                    tb_cds_cad_domiciliar.ds_complemento,
                                    tb_cds_cad_domiciliar.no_bairro,
                                    tb_cds_cad_domiciliar.co_municipio,
                                    tb_cds_cad_domiciliar.nu_cep,
                                    tb_cds_cad_domiciliar.co_uf,
                                    tb_cds_cad_domiciliar.nu_micro_area,
                                    tb_cds_cad_domiciliar.nu_latitude,
                                    tb_cds_cad_domiciliar.nu_longitude,
                                    tb_cds_cad_domiciliar.tp_logradouro
                                FROM
                                (
                                    SELECT
                                        t1.*,
                                        tb_cds_domicilio_familia.co_cds_cad_domiciliar
                                    FROM
                                    (
                                        SELECT 
                                            nu_celular_cidadao, 
                                            nu_cns_cidadao,
                                            nu_cpf_cidadao,
                                            nu_cartao_sus_responsavel,
                                            nu_cpf_responsavel
                                        FROM
                                            tb_cds_cad_individual
                                        WHERE
                                            translate(no_cidadao,'áàâãäåaaaÁÂÃÄÅAAAÀéèêëeeeeeEEEÉEEÈìíîïìiiiÌÍÎÏÌIIIóôõöoooòÒÓÔÕÖOOOùúûüuuuuÙÚÛÜUUUUçÇñÑýÝ','aaaaaaaaaAAAAAAAAAeeeeeeeeeEEEEEEEiiiiiiiiIIIIIIIIooooooooOOOOOOOOuuuuuuuuUUUUUUUUcCnNyY') LIKE '".$this->visitas[$conta_array]['nome']."%' 
                                            AND (dt_nascimento >= '".$this->visitas[$conta_array]['dtNascimento']." 00:00:00' AND dt_nascimento <= '".$this->visitas[$conta_array]['dtNascimento']." 23:59:59') 
                                            ".$query_mae."
                                        ORDER BY co_seq_cds_cad_individual DESC LIMIT 1
                                    ) AS t1
                                    LEFT JOIN tb_cds_domicilio_familia
                                    ON tb_cds_domicilio_familia.nu_cartao_sus = t1.nu_cns_cidadao OR tb_cds_domicilio_familia.nu_cpf_cidadao = t1.nu_cpf_cidadao
                                    ORDER BY tb_cds_domicilio_familia.co_seq_cds_domicilio_familia DESC LIMIT 1
                                ) AS t2
                                LEFT JOIN tb_cds_cad_domiciliar
                                ON tb_cds_cad_domiciliar.co_seq_cds_cad_domiciliar = t2.co_cds_cad_domiciliar
                            ) AS t3
                            LEFT JOIN tb_tipo_logradouro
                            ON tb_tipo_logradouro.co_tipo_logradouro = t3.tp_logradouro
                        ) AS t4
                        LEFT JOIN tb_uf
                        ON tb_uf.co_uf = t4.co_uf
                        ";
                        $encontrou = false;
                        $rsl = $this->con->prepare($sql4);
                        if($rsl->execute()){
                            if($rsl->rowCount() > 0){
                                while($rowsl = $rsl->fetch(PDO::FETCH_OBJ)){
                                    $this->visitas[$conta_array]['cns_responsavel'] = $rowsl->nu_cartao_sus_responsavel;
                                    $this->visitas[$conta_array]['cpf_responsavel'] = $rowsl->nu_cpf_responsavel;
                                    if (strlen($rowsl->no_logradouro) > 0){
                                        $encontrou = true;
                                        $this->visitas[$conta_array]['uf'] = $rowsl->sg_uf;
                                        $this->visitas[$conta_array]['bairro'] = $rowsl->no_bairro;
                                        $this->visitas[$conta_array]['logradouro'] = $rowsl->no_logradouro;
                                        $this->visitas[$conta_array]['numero'] = $rowsl->nu_domicilio;
                                        $this->visitas[$conta_array]['complemento'] = $rowsl->ds_complemento;
                                        $this->visitas[$conta_array]['tipoLogradouro'] = $rowsl->no_tipo_logradouro;
                                    }
                                }
                            }
                        }
                        if (!$encontrou){
                            $sql_resp = "
                                SELECT
                                    t4.no_logradouro,
                                    t4.nu_domicilio,
                                    t4.ds_complemento,
                                    t4.no_bairro,
                                    t4.nu_cep,
                                    t4.nu_micro_area,
                                    t4.nu_latitude,
                                    t4.nu_longitude,
                                    t4.no_tipo_logradouro,
                                    tb_uf.no_uf,
                                    tb_uf.sg_uf
                                FROM
                                (
                                    SELECT
                                        t3.*,
                                        tb_tipo_logradouro.no_tipo_logradouro
                                    FROM
                                    (
                                        SELECT 
                                            t2.*,
                                            tb_cds_cad_domiciliar.no_logradouro,
                                            tb_cds_cad_domiciliar.nu_domicilio,
                                            tb_cds_cad_domiciliar.ds_complemento,
                                            tb_cds_cad_domiciliar.no_bairro,
                                            tb_cds_cad_domiciliar.co_municipio,
                                            tb_cds_cad_domiciliar.nu_cep,
                                            tb_cds_cad_domiciliar.co_uf,
                                            tb_cds_cad_domiciliar.nu_micro_area,
                                            tb_cds_cad_domiciliar.nu_latitude,
                                            tb_cds_cad_domiciliar.nu_longitude,
                                            tb_cds_cad_domiciliar.tp_logradouro
                                        FROM
                                        (
                                            SELECT
                                                co_cds_cad_domiciliar
                                            FROM
                                                tb_cds_domicilio_familia
                                            WHERE
                                                nu_cartao_sus = '".$this->visitas[$conta_array]['cns_responsavel']."' OR nu_cpf_cidadao = '".$this->visitas[$conta_array]['cpf_responsavel']."' LIMIT 1
                                        ) AS t2
                                        LEFT JOIN tb_cds_cad_domiciliar
                                        ON tb_cds_cad_domiciliar.co_seq_cds_cad_domiciliar = t2.co_cds_cad_domiciliar
                                    ) AS t3
                                    LEFT JOIN tb_tipo_logradouro
                                    ON tb_tipo_logradouro.co_tipo_logradouro = t3.tp_logradouro
                                ) AS t4
                                LEFT JOIN tb_uf
                                ON tb_uf.co_uf = t4.co_uf
                            ";
                            $rsl2 = $this->con->prepare($sql_resp);
                            if($rsl2->execute()){
                                if($rsl2->rowCount() > 0){
                                    while($rowsl2 = $rsl2->fetch(PDO::FETCH_OBJ)){
                                        $this->visitas[$conta_array]['uf'] = $rowsl2->sg_uf;
                                        $this->visitas[$conta_array]['bairro'] = $rowsl2->no_bairro;
                                        $this->visitas[$conta_array]['logradouro'] = $rowsl2->no_logradouro;
                                        $this->visitas[$conta_array]['numero'] = $rowsl2->nu_domicilio;
                                        $this->visitas[$conta_array]['complemento'] = $rowsl2->ds_complemento;
                                        $this->visitas[$conta_array]['tipoLogradouro'] = $rowsl2->no_tipo_logradouro;
                                    }
                                }
                            }
                        }
                    }

					$conta_array++;
                    $this->ultimaVisita = $rows->co_dim_tempo;
				}
			}
		}
    }
    public function total() {
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
			if($this->totalEncontrado > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->primeiraVisita = $rows->co_dim_tempo;
					break;
				}
			}
		}
    }
}

?>