<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Procedimentos</h4>
                </div>
                <div class="card-body mt-2">
<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');

$scsus_demo = false;
if (isset($scsus_demonstracao)){
    if ($scsus_demonstracao){
        $scsus_demo = true;
    }
}

$f_calibra = "calibracao.php";
if (file_exists($f_calibra)){
    include $f_calibra;
}

$dti = fgpa('i');
$dtf = fgpa('f');
$idin = 0;
$idfi = 150;
$procs = '';
$sexo = 'A';
$cpf = '';
$cns = '';
$avso = 'A';
$metodo = 1;
$sexo_moh = "T";

$rs = $con->prepare("SELECT * FROM cidadao_tb_cf_procedimentos WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
			$dti = $row->dti;
			$dtf = $row->dtf;
            $idin = $row->idin;
            $idfi = $row->idfi;
            $cpf = $row->cpf;
            $cns = $row->cns;
            $procs = $row->procs;
            $sexo = $row->sexo;
            $avso = $row->avso;
            $metodo = $row->metodo;
		}
	}
}

$sexo_m = $sexo;
if ($sexo_m == 'A'){
    $sexo_m = "Ambos";
}
$avso_m = $avso;
if ($avso_m == 'A'){
    $avso_m = "Ambos";
} elseif ($avso_m == 'V'){
    $avso_m = "Avaliados";
} else {
    $avso_m = "Solicitados";
}
$metodo_m = $metodo;
if ($metodo_m == '1'){
    $metodo_m = "Apenas quem atende aos critérios";
} else {
    $metodo_m = "Todos";
}
echo "
                    <p class=\"card-text\">
                        Data inicial: ".datanas6($dti)." | Data final: ".datanas6($dtf)."<br>
                        Idade inicial: ".$idin." | Idade final: ".$idfi."<br>
                        CPF: ".$cpf."<br>
                        CNS: ".$cns."<br>
                        Sexo: ".$sexo_m."<br>
                        Avaliados e/ou Solicitados: ".$avso_m."<br>
                        Método: ".$metodo_m."<br>
                        Procedimentos: ".$procs."<br>
                        Gerado em: ".date('d/m/Y H:i:s')."
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
";

// --------------------------------------------------------
$ar_procs = explode(";",$procs);
$vr_procs = false;
if (count($ar_procs) == 1){
    if (strlen($ar_procs[0]) > 0){
        $vr_procs = true;
    }
} elseif (count($ar_procs) > 1){
    $vr_procs = true;
}
$w_procs_av = "";
$w_procs_so = "";
if ($vr_procs){
    $w_procs_av = "ds_filtro_proced_avaliados LIKE ANY (array[";
    $w_procs_so = "ds_filtro_proced_solicitados LIKE ANY (array[";
    foreach ($ar_procs as $v) {
        $w_procs_av .= "'%|".$v."|%',";
        $w_procs_so .= "'%|".$v."|%',";
    }
    $w_procs_av = substr($w_procs_av,0,-1);
    $w_procs_av .= "])";
    $w_procs_so = substr($w_procs_so,0,-1);
    $w_procs_so .= "])";
}
// --------------------------------------------------------
$w_procs_avso = "";
if ($avso == 'A'){
    if (strlen($w_procs_av) > 0 && strlen($w_procs_so) > 0){
        $w_procs_avso = "and (".$w_procs_av." or ".$w_procs_so.")";
    }
} elseif ($avso == 'V'){
    if (strlen($w_procs_av) > 0){
        $w_procs_avso = "and ".$w_procs_av;
    }
} else {
    if (strlen($w_procs_so) > 0){
        $w_procs_avso = "and ".$w_procs_so;
    }
}
// --------------------------------------------------------
$ar_cpf = explode(";",$cpf);
$vr_cpf = false;
if (count($ar_cpf) == 1){
    if (strlen($ar_cpf[0]) > 0){
        $vr_cpf = true;
    }
} elseif (count($ar_cpf) > 1){
    $vr_cpf = true;
}
$w_cpf = "";
if ($vr_cpf){
    $w_cpf = "nu_cpf_cidadao LIKE ANY (array[";
    foreach ($ar_cpf as $v) {
        $w_cpf .= "'".$v."',";
    }
    $w_cpf = substr($w_cpf,0,-1);
    $w_cpf .= "])";
}
// --------------------------------------------------------
$ar_cns = explode(";",$cns);
$vr_cns = false;
if (count($ar_cns) == 1){
    if (strlen($ar_cns[0]) > 0){
        $vr_cns = true;
    }
} elseif (count($ar_cns) > 1){
    $vr_cns = true;
}
$w_cns = "";
if ($vr_cns){
    $w_cns = "nu_cns LIKE ANY (array[";
    foreach ($ar_cns as $v) {
        $w_cns .= "'".$v."',";
    }
    $w_cns = substr($w_cns,0,-1);
    $w_cns .= "])";
}
// --------------------------------------------------------
$w_cpf_cns = "";
if (strlen($w_cpf) > 0){
    $w_cpf_cns = "and ".$w_cpf;
    if (strlen($w_cns) > 0){
        $w_cpf_cns = "and (".$w_cpf_cns." or ".$w_cns.")";
    }
} else {
    if (strlen($w_cns) > 0){
        $w_cpf_cns = "and ".$w_cns;
    }
}
// --------------------------------------------------------
$w_dtnas = "";
if (strlen($idfi) > 0 && strlen($idfi) > 0){
    if ($idfi > $idin){
        $data_atual = date('Ymd');
        $dia_atual = substr($data_atual,6,2);
        $mes_atual = substr($data_atual,4,2);
        $ano_atual = (int) substr($data_atual,0,4);
        $adi = $ano_atual - $idfi - 1;
        $adf = $ano_atual - $idin;
        $dt1 = $adi.'-'.$mes_atual.'-'.$dia_atual;
        $dt2 = $adf.'-'.$mes_atual.'-'.$dia_atual;
        $w_dtnas = "and (dt_nascimento > '".$dt1."' and dt_nascimento <= '".$dt2."')";
    }
}
// --------------------------------------------------------
$w_sexo = "";
if ($sexo == 'M'){
    $w_sexo = "where sg_sexo = 'M'";
    $sexo_moh = "MASCULINO";
} elseif ($sexo == 'F'){
    $w_sexo = "where sg_sexo = 'F'";
    $sexo_moh = "FEMININO";
}
// --------------------------------------------------------

include($path_local_raiz.'class/_cidadao.class.php');
include($path_local_raiz.'class/_procedimentos.class.php'); 

if ($metodo == 9){
    /*
    co_dim_cbo
    co_dim_unidade_saude
    co_dim_equipe
    co_dim_profissional
    co_seq_fat_atd_ind
    co_dim_municipio
    co_dim_tipo_ficha
    co_dim_profissional_1
    co_dim_profissional_2
    co_dim_cbo_1
    co_dim_cbo_2
    co_dim_unidade_saude_1
    co_dim_unidade_saude_2
    co_dim_equipe_1
    co_dim_equipe_2
    co_dim_tempo
    co_dim_racionalidade_saude
    nu_uuid_ficha
    nu_atendimento
    nu_cns
    dt_nascimento
    co_dim_faixa_etaria
    co_dim_sexo
    co_dim_turno
    co_dim_local_atendimento
    co_dim_tipo_atendimento
    nu_peso
    nu_altura
    nu_perimetro_cefalico
    st_vacinacao_em_dia
    co_dim_aleitamento
    co_dim_tempo_dum
    st_gravidez_planejada
    nu_idade_gestacional_semanas
    nu_gestas_previas
    nu_partos
    co_dim_modalidade_ad
    st_ficou_em_observacao
    st_nasf_avaliacao_diagnostico
    st_nasf_proce_clin_terapeutico
    st_nasf_prescricao_terapeutica
    st_conduta_consulta_agendada
    st_conduta_cuidd_conti_program
    st_conduta_agendamento_grupos
    st_conduta_agendamento_nasf
    st_conduta_alta_episodio
    st_encaminhamento_interno_dia
    st_encaminhamento_serv_special
    st_encaminhamento_caps
    st_encaminhamento_intern_hospi
    st_encaminhamento_urgencia
    st_encaminhamento_servico_ad
    st_encaminhamento_intersetoria
    ds_filtro_cids
    ds_filtro_ciaps
    ds_filtro_proced_avaliados
    ds_filtro_proced_solicitados
    nu_prontuario
    nu_uuid_dado_transp
    co_dim_tipo_origem_dado_transp
    co_dim_cds_tipo_origem
    co_fat_cidadao_pec
    dt_inicial_atendimento
    dt_final_atendimento
    nu_cpf_cidadao
    nu_cnes
    no_unidade_saude
    nu_ine
    no_equipe
    nu_cns_profissional
    no_profissional
    nu_cbo
    no_cbo
    co_cidadao
    ds_sexo
    sg_sexo
    */

    $sql = "
    select
        t6.*,
        tb_dim_sexo.ds_sexo,
        tb_dim_sexo.sg_sexo
    from
    (
        select
            t5.*,
            tb_fat_cidadao_pec.co_cidadao
        from
        (
            select
                t4.*,
                tb_dim_cbo.nu_cbo,
                tb_dim_cbo.no_cbo
            from
            (
                select
                    t3.*,
                    tb_dim_profissional.nu_cns as nu_cns_profissional,
                    tb_dim_profissional.no_profissional
                from
                (
                    select
                        t2.*,
                        tb_dim_equipe.nu_ine,
                        tb_dim_equipe.no_equipe
                    from
                    (
                        select
                            t1.*,
                            tb_dim_unidade_saude.nu_cnes,
                            tb_dim_unidade_saude.no_unidade_saude
                        from
                        (
                            select
                                CASE WHEN co_dim_cbo_1 = 1 THEN co_dim_cbo_2
                                    ELSE co_dim_cbo_1 END
                                    co_dim_cbo,
                                CASE WHEN co_dim_unidade_saude_1 = 1 THEN co_dim_unidade_saude_2
                                    ELSE co_dim_unidade_saude_1 END
                                    co_dim_unidade_saude,
                                CASE WHEN co_dim_equipe_1 = 1 THEN co_dim_equipe_2
                                    ELSE co_dim_equipe_1 END
                                    co_dim_equipe,
                                CASE WHEN co_dim_profissional_1 = 1 THEN co_dim_profissional_2
                                    ELSE co_dim_profissional_1 END
                                    co_dim_profissional,
                                *
                            from 
                                tb_fat_atendimento_individual
                            where
                                (co_dim_tempo >= ".$dti." and co_dim_tempo <= ".$dtf.")
                                ".$w_cpf_cns."
                                ".$w_procs_avso."
                                ".$w_dtnas."
                        ) as t1
                        left join
                            tb_dim_unidade_saude
                        on t1.co_dim_unidade_saude = tb_dim_unidade_saude.co_seq_dim_unidade_saude
                    ) as t2
                    left join
                        tb_dim_equipe
                    on t2.co_dim_equipe = tb_dim_equipe.co_seq_dim_equipe
                ) as t3
                left join
                    tb_dim_profissional
                on t3.co_dim_profissional = tb_dim_profissional.co_seq_dim_profissional
            ) as t4
            left join
                tb_dim_cbo
            on t4.co_dim_cbo = tb_dim_cbo.co_seq_dim_cbo
        ) as t5
        left join
            tb_fat_cidadao_pec
        on t5.co_fat_cidadao_pec = tb_fat_cidadao_pec.co_seq_fat_cidadao_pec
    ) as t6
    left join
        tb_dim_sexo
    on t6.co_dim_sexo = tb_dim_sexo.co_seq_dim_sexo
    ".$w_sexo."
    order by co_fat_cidadao_pec, co_dim_tempo
    ";

    echo "
        <table id=\"tbdt\" class=\"table table-striped\">
        <thead>
            <tr>
                <th>CPF</th>
                <th>CNS</th>
                <th>Nome</th>
                <th>Mae</th>
                <th>DtNascimento</th>
                <th>Idade</th>
                <th>CNS Prof.</th>
                <th>Profissional</th>
                <th>Data</th>
                <th>INE</th>
                <th>CNES</th>
                <th>Proc AV</th>
                <th>Proc SO</th>
            </tr>
        </thead>
        <tbody>
    ";

    $rs = $cdb->prepare($sql);
    if($rs->execute()){
        if($rs->rowCount() > 0){
            while($row = $rs->fetch(PDO::FETCH_OBJ)){
                $pec_cidadao = trim($row->co_cidadao);
                $pec_cns = trim($row->nu_cns);
                $pec_cpf = trim($row->nu_cpf_cidadao);
                $cid = new Cidadao($cdb, $pec_cns, $pec_cpf, null, null, '', '', '');
                $cid->dados();
                // ...........................................................................................................
                $proc_solicitado = str_replace(" ","",substr(substr($row->ds_filtro_proced_solicitados,0,-1),1));
                $proc_avaliado = str_replace(" ","",substr(substr($row->ds_filtro_proced_avaliados,0,-1),1));
                $array_procs_av = explode("|",$proc_avaliado);
                $array_procs_so = explode("|",$proc_solicitado);
                $apenas_av = array_intersect($array_procs_av,$ar_procs);
                $apenas_so = array_intersect($array_procs_so,$ar_procs);
                $show_proc_so = "";
                $show_proc_av = "";
                foreach ($apenas_so as $value1){
                    $show_proc_so .= $value1."|";
                }
                $show_proc_so = substr($show_proc_so,0,-1);
                foreach ($apenas_av as $value){
                    $show_proc_av .= $value."|";
                }
                $show_proc_av = substr($show_proc_av,0,-1);
                // ...........................................................................................................
                $pec_cid_cpf = $cid->cpf;
                $pec_cid_cns = $cid->cns;
                $pec_cid_nome = trim($cid->nome);
                $pec_cid_mae = trim($cid->mae);
                $pec_cid_dtnas = datanas2($row->dt_nascimento);
                $idade = idadeint(datanas3($row->dt_nascimento),date('Ymd'));
                if (strlen($pec_cid_nome) <= 0){
                    if (strlen($pec_cidadao) > 0){
                        $cidn = new CidadaoFAT($cdb, $pec_cidadao);
                        $cidn->dados();
                        $pec_cid_cpf = $cidn->cpf;
                        $pec_cid_cns = $cidn->cns;
                        $pec_cid_nome = trim($cidn->nome);
                        $pec_cid_mae = trim($cidn->mae);
                    }
                }
                if (strlen($pec_cid_nome) > 0){
                    echo "<tr>";
                        echo "<td>".$pec_cid_cpf."</td>";
                        echo "<td>".$pec_cid_cns."</td>";
                        echo "<td>".$pec_cid_nome."</td>";
                        echo "<td>".$pec_cid_mae."</td>";
                        echo "<td>".$pec_cid_dtnas."</td>";
                        echo "<td>".$idade."</td>";
                        echo "<td>".$row->nu_cns_profissional."</td>";
                        echo "<td>".$row->no_profissional."</td>";
                        echo "<td>".datanas6($row->co_dim_tempo)."</td>";
                        echo "<td>".$row->nu_ine."</td>";
                        echo "<td>".$row->nu_cnes."</td>";
                        echo "<td>".$show_proc_av."</td>";
                        echo "<td>".$show_proc_so."</td>";
                    echo "</tr>";
                }
            }
        }
    }
    echo "
        </tbody>
        </table>
    ";
} else {
    echo "
        <table id=\"tbdt\" class=\"table table-striped\">
        <thead>
            <tr>
                <th>TP</th>
                <th>CPF</th>
                <th>CNS</th>
                <th>Nome</th>
                <th>Mae</th>
                <th>DtNascimento</th>
                <th>Idade/Hoje</th>
                <th>CNS Prof.</th>
                <th>Profissional</th>
                <th>Data</th>
                <th>INE</th>
                <th>CNES</th>
                <th>Proc AV</th>
                <th>Proc SO</th>
            </tr>
        </thead>
        <tbody>
    ";
    $ctrl_duplicado = array();
    $idinn = $idin*12;
    $idfin = $idfi*12+11;
    $cids = new Cidadaos($cdb, $sexo_moh, $idinn, $idfin, $dti, $dtf);
    $cids->todos();
    if ($cids->totalEncontrado > 0){
        for ($i=0;$i<count($cids->cidadaos);$i++){

            $pec_cid_cpf = $cids->cidadaos[$i]['cpf'];
            $pec_cid_cns = $cids->cidadaos[$i]['cns'];
            $pec_cid_nome = $cids->cidadaos[$i]['nome'];
            $pec_cid_mae = $cids->cidadaos[$i]['mae'];
            $pec_cid_dtnas = "0000-00-00";
            $pec_cid_dtnas = datanas2($cids->cidadaos[$i]['dtNascimento']);
            $idade = idadeint(datanas3($cids->cidadaos[$i]['dtNascimento']),$dtf);
            $idade_hoje = idadeint(datanas3($cids->cidadaos[$i]['dtNascimento']),date('Ymd'));

            $ctrl = $pec_cid_cpf.$pec_cid_cns.$pec_cid_nome.$pec_cid_mae;

            $mostrar = false;
            if ($vr_cpf){
                if (in_array($pec_cid_cpf, $ar_cpf)){
                    $mostrar = true;
                }
            }
            if ($vr_cns){
                if (in_array($pec_cid_cns, $ar_cns)){
                    $mostrar = true;
                }
            }
            if (!$vr_cpf && !$vr_cns){
                $mostrar = true;
            }

            if ($scsus_demo){
                $pec_cid_cpf = "***.***.***-**";
                $pec_cid_cns = "***************";
                $pec_cid_nome = "********** ********* ***********";
                $pec_cid_mae = "******* ********** ************";
                $pec_cid_dtnas = "**/**/****";
            }

            if ($mostrar){
                if (strlen($cids->cidadaos[$i]['cidadao']) > 0){
                    if (isset($calibracao_procs)){
                        if ($calibracao_procs == 'C'){
                            $procs = new Procedimentos($cdb, $cids->cidadaos[$i]['cns'], $cids->cidadaos[$i]['cpf'], '', '', $dti, $dtf, array(), $ar_procs);
                        } else {
                            $procs = new ProcedimentosFAT($cdb, $cids->cidadaos[$i]['cidadao'], $dti, $dtf, array(), $ar_procs);
                        }
                    } else {
                        $procs = new ProcedimentosFAT($cdb, $cids->cidadaos[$i]['cidadao'], $dti, $dtf, array(), $ar_procs);
                    }
                } else {
                    $procs = new Procedimentos($cdb, $cids->cidadaos[$i]['cns'], $cids->cidadaos[$i]['cpf'], '', '', $dti, $dtf, array(), $ar_procs);
                }
    
                $procs->todos();
                if ($procs->totalEncontrado > 0){
                    for ($k=0;$k<count($procs->procedimentos);$k++){

                        $proc_solicitado = str_replace(" ","",substr(substr($procs->procedimentos[$k]['solicitado'],0,-1),1));
                        $proc_avaliado = str_replace(" ","",substr(substr($procs->procedimentos[$k]['avaliado'],0,-1),1));

                        $ctrl .= $procs->procedimentos[$k]['dtConsulta'].$proc_solicitado.$proc_avaliado;

                        $array_procs_av = explode("|",$proc_avaliado);
                        $array_procs_so = explode("|",$proc_solicitado);

                        $apenas_av = array_intersect($array_procs_av,$ar_procs);
                        $apenas_so = array_intersect($array_procs_so,$ar_procs);

                        $show_proc_av = "";
                        $show_proc_so = "";
                        if ($vr_procs){
                            foreach ($apenas_av as $value){
                                $show_proc_av .= $value."|";
                            }
                            foreach ($apenas_so as $value1){
                                $show_proc_so .= $value1."|";
                            }
                        } else {
                            foreach ($array_procs_av as $value){
                                $show_proc_av .= $value."|";
                            }
                            foreach ($array_procs_so as $value1){
                                $show_proc_so .= $value1."|";
                            }
                        }

                        $mostrar_det = false;
                        if ($vr_procs){
                            if ($avso == 'A'){
                                $mostrar_det = true;
                            } else {
                                if ($avso == 'V'){
                                    if (count($apenas_av) > 0){
                                        if (count($apenas_av) == 1){
                                            if (isset($apenas_av[0])){
                                                if (strlen(trim($apenas_av[0])) > 2){
                                                    $mostrar_det = true;
                                                }
                                            }
                                        } else {
                                            $mostrar_det = true;
                                        }
                                    }
                                } else {
                                    if (count($apenas_so) > 0){
                                        if (count($apenas_so) == 1){
                                            if (isset($apenas_so[0])){
                                                if (strlen(trim($apenas_so[0])) > 2){
                                                    $mostrar_det = true;
                                                }
                                            }
                                        } else {
                                            $mostrar_det = true;
                                        }
                                    }
                                }
                            }
                        } else {
                            $mostrar_det = true;
                        }

                        $show_proc_cnsprofissional = $procs->procedimentos[$k]['cnsProfissional'];
                        $show_proc_nomeprofissional = $procs->procedimentos[$k]['nomeProfissional'];
                        $show_proc_ine = $procs->procedimentos[$k]['ine'];
                        $show_proc_cnes = $procs->procedimentos[$k]['cnes'];
                        if ($scsus_demo){
                            $show_proc_cnsprofissional = "***************";
                            $show_proc_nomeprofissional = "******** ********* ***********";
                            $show_proc_ine = "0000******";
                            $show_proc_cnes = "******";
                        }

                        if ($mostrar_det){
                            if (!in_array($ctrl, $ctrl_duplicado)){
                                echo "<tr>";
                                    echo "<td>SIM</td>";
                                    echo "<td>".$pec_cid_cpf."</td>";
                                    echo "<td>".$pec_cid_cns."</td>";
                                    echo "<td>".$pec_cid_nome."</td>";
                                    echo "<td>".$pec_cid_mae."</td>";
                                    echo "<td>".$pec_cid_dtnas."</td>";
                                    echo "<td>".$idade."/".$idade_hoje."</td>";
                                    echo "<td>".$show_proc_cnsprofissional."</td>";
                                    echo "<td>".$show_proc_nomeprofissional."</td>";
                                    echo "<td>".datanas6($procs->procedimentos[$k]['dtConsulta'])."</td>";
                                    echo "<td>".$show_proc_ine."</td>";
                                    echo "<td>".$show_proc_cnes."</td>";
                                    echo "<td>".$show_proc_av."</td>";
                                    echo "<td>".$show_proc_so."</td>";
                                echo "</tr>";
                                $ctrl_duplicado[] = $ctrl;
                            }
                        }

                    }
                } else {
                    if ($metodo == 2){
                        echo "<tr>";
                            echo "<td>NAO</td>";
                            echo "<td>".$pec_cid_cpf."</td>";
                            echo "<td>".$pec_cid_cns."</td>";
                            echo "<td>".$pec_cid_nome."</td>";
                            echo "<td>".$pec_cid_mae."</td>";
                            echo "<td>".$pec_cid_dtnas."</td>";
                            echo "<td>".$idade."/".$idade_hoje."</td>";
                            echo "<td></td>";
                            echo "<td></td>";
                            echo "<td></td>";
                            echo "<td></td>";
                            echo "<td></td>";
                            echo "<td></td>";
                            echo "<td></td>";
                        echo "</tr>";
                    }
                }
            }
        }
    }
    echo "
        </tbody>
        </table>
    ";
}



?>
<script>
    SlickLoader.disable();
    $(document).ready(function() {
        $('#tbdt').DataTable({
            responsive: true,
            lengthChange: true, 
            orderCellsTop: true,
            autoWidth: false,
            language: {
                lengthMenu: 'Mostrando _MENU_ registros por página',
                zeroRecords: 'Nenhum encontrado - Desculpe',
                info: 'Mostrando página _PAGE_ de _PAGES_',
                infoEmpty: 'Nenhum registro encontrado',
                infoFiltered: '(filtrando por _MAX_ de um total de registros)',
                search: 'Busca',
                decimal: ',',
                thousands: '.',
                paginate: {
                  previous: '&nbsp;',
                  next: '&nbsp;'
                }
            },
            dom: 'Bfrtip',
            buttons: [
                'excelHtml5',
                'csvHtml5'
            ]
        });
    });
</script>