<?php
date_default_timezone_set('America/Sao_Paulo');
session_set_cookie_params(["SameSite" => "Strict"]); //none, lax, strict
session_set_cookie_params(["Secure" => "true"]); //false, true
session_set_cookie_params(["HttpOnly" => "true"]); //false, true
session_start();
session_unset();
session_destroy();

require_once('../../cfg/mydb.php');
require_once('../../core/con_my.php');
require_once('../../core/functions.php');

$cpf = isset($_POST["cpf"]) ? trim($_POST["cpf"]) : 'xxxxxxxxxxx';
if (strlen($cpf) > 0){
    $cpf = str_replace("_","",$cpf);
    $cpf = str_replace(".","",$cpf);
    $cpf = str_replace("-","",$cpf);
} else {
    $cpf = 'xxxxxxxxxxx';
}
$cns = isset($_POST["cns"]) ? trim($_POST["cns"]) : 'xxxxxxxxxxxxxxx';
if (strlen($cns) > 0){
    $cns = str_replace("_","",$cns);
} else {
    $cns = 'xxxxxxxxxxxxxxx';
}
$datanas = isset($_POST["datanas"]) ? trim($_POST["datanas"]) : '';
$tk = isset($_POST["tk"]) ? trim($_POST["tk"]) : '';
$sv = isset($_POST["sv"]) ? trim($_POST["sv"]) : '';

$retorno = "";
$ok = false;

$esus_nome = "";
$esus_cns = "";
$esus_cpf = "";
$esus_co_cidadao = "";
$esus_datanas = "";
$esus_ativo = "";
$esus_dobito = "";
$esus_faleceu = "";
$id_login = "";
$id_ibge = "";

if ((strlen($cpf) > 0 || strlen($cns) > 0) && strlen($datanas) > 0 && strlen($tk) > 0){
    $datanas = datanas1($datanas);
    $id_kiosk = 0;
    $dbhost = "localhost";
    $dbport = "5433";
    $dbdb = "esus";
    $dbuser = "postgres";
    $dbpass = "esus";
    $rs = $con->prepare("SELECT * FROM kiosk_tb_kiosk WHERE token = ? LIMIT 1");
    $rs->bindParam(1,$tk);
    if($rs->execute()){
        if($rs->rowCount() > 0){
            while($row = $rs->fetch(PDO::FETCH_OBJ)){
                $id_kiosk = $row->idg;
                $id_login = $row->id;
                $id_ibge = $row->ibge;
            }
        }
    }
    $encontrou_dados_banco = false;
    if (strlen($id_login) > 0){
        $rs = $con->prepare("SELECT * FROM sc_tb_cf_db WHERE id = ? AND ibge = ? LIMIT 1");
        $rs->bindParam(1,$id_login);
        $rs->bindParam(2,$id_ibge);
        if($rs->execute()){
            if($rs->rowCount() > 0){
                $encontrou_dados_banco = true;
                while($row = $rs->fetch(PDO::FETCH_OBJ)){
                    $dbhost = $row->host;
                    $dbport = $row->port; 
                    $dbdb = $row->dbname;
                    $dbuser = $row->user;
                    $dbpass = $row->pass; 
                }
            }
        }
    }
    if ($encontrou_dados_banco){
        require_once('../../core/con_pg.php');
        if ($cdbokpg){
            $sql = "
                SELECT 
                    co_seq_cidadao,
                    st_ativo, 
                    nu_cpf, 
                    nu_cns, 
                    no_cidadao,
                    dt_nascimento,
                    dt_obito,
                    st_faleceu
                FROM
                    tb_cidadao
                WHERE
                    nu_cns = ? OR nu_cpf = ?
                ORDER BY co_seq_cidadao DESC LIMIT 1
            ";
            $rs = $cdb->prepare($sql);
            $rs->bindParam(1,$cns);
            $rs->bindParam(2,$cpf);
            if($rs->execute()){
                if($rs->rowCount() > 0){
                    while($row = $rs->fetch(PDO::FETCH_OBJ)){
                        $esus_nome = $row->no_cidadao;
                        $esus_cns = $row->nu_cns;
                        $esus_cpf = $row->nu_cpf;
                        $esus_co_cidadao = $row->co_seq_cidadao;
                        $esus_datanas = $row->dt_nascimento;
                        $esus_ativo = $row->st_ativo;
                        $esus_dobito = $row->dt_obito;
                        $esus_faleceu = $row->st_faleceu;
                    }
                    if ($esus_datanas == $datanas){
                        if ($esus_ativo == 1){
                            if ($esus_faleceu == 0){
                                $ok = true;
                            } else {
                                $retorno = "Fomos informados que você já faleceu!";
                            }
                        } else {
                            $retorno = "Seu cadastro não está ativo";
                        }
                    } else {
                        $retorno = "Se passando por outra pessoa??";
                    }
                } else {
                    $retorno = "Cidadão não encontrado";
                }
            }
        } else {
            $retorno = " Não foi possível conectar ao e-SUS";
        }
    }
} else {
    $retorno = "Erro, ao enviar dados do formulário.";
}

if ($ok){
    $retorno = "Ok";
    $sessao_nome = $id_login.$id_ibge.date('Ymdhis');
    $_COOKIE[$sessao_nome] = session_create_id();
    session_id($_COOKIE[$sessao_nome]);
    session_start();
    $_SESSION['nome'] = $esus_nome;
    $_SESSION['cns'] = $esus_cns;
    $_SESSION['cpf'] = $esus_cpf;
    $_SESSION['co_cidadao'] = $esus_co_cidadao;
    $_SESSION['ssl'] = $id_login;
    $_SESSION['ssi'] = $id_ibge;
    $_SESSION['tk'] = $tk;
    $_SESSION['sv'] = $sv;
    $_SESSION['ctrl'] = '0';
}

echo $retorno;
?>