<?php
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//    
//    
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
date_default_timezone_set('America/Sao_Paulo');
ini_set('max_execution_time', 0);
ini_set("memory_limit", "-1");
ini_set("session.use_strict_mode",true);
ini_set("session.cookie_httponly",true);
session_set_cookie_params(["SameSite" => "Strict"]); //none, lax, strict
session_set_cookie_params(["Secure" => "true"]); //false, true
session_set_cookie_params(["HttpOnly" => "true"]); //false, true

if (!isset($ctrl_r)){
	$ctrl_r = false;
}

require_once('../../core/sp.php');
require_once('../../core/functions.php');
require_once('../../cfg/mydb.php');
require_once('../../core/con_my.php');
require_once('parametros.php');

$sec_deslogar = false;
$sec_mensagem = "";

$sec_cid_datanas = "";
$sec_cid_sexo = "";

session_start();
if (!isset($_SESSION['cns']) || !isset($_SESSION['cpf'])){
	$sec_deslogar = true;
	$sec_mensagem .= "Seção não encontrada | ";
} else {
    $encontrou = false;
    $dbhost = "localhost";
    $dbport = "5433";
    $dbdb = "esus";
    $dbuser = "postgres";
    $dbpass = "esus";
    $rs = $con->prepare("SELECT * FROM sc_tb_cf_db WHERE id = ? AND ibge = ? LIMIT 1");
    $rs->bindParam(1,$_SESSION['ssl']);
    $rs->bindParam(2,$_SESSION['ssi']);
    if($rs->execute()){
        if($rs->rowCount() > 0){
            $encontrou = true;
            while($row = $rs->fetch(PDO::FETCH_OBJ)){
                $dbhost = $row->host;
                $dbport = $row->port; 
                $dbdb = $row->dbname;
                $dbuser = $row->user;
                $dbpass = $row->pass; 
            }
        }
    }
    if ($encontrou){
        require_once('../../core/con_pg.php');
        if ($cdbokpg){
            $sql = "
                SELECT 
                    co_seq_cidadao,
                    co_localidade,
                    nu_area,
                    nu_micro_area,
                    dt_atualizado,
                    nu_cns_responsavel,
                    no_responsavel, 
                    co_unico_cidadao, 
                    st_fora_area, 
                    st_compartilhamento_prontuario,
                    st_ativo, 
                    nu_cpf, 
                    nu_cns, 
                    no_cidadao,
                    dt_nascimento,
                    dt_obito,
                    no_mae,
                    st_faleceu, 
                    ds_cep,
                    ds_complemento,
                    ds_ponto_referencia,
                    ds_logradouro,
                    co_uf,
                    co_localidade_endereco,
                    nu_numero,
                    st_sem_numero,
                    no_bairro,
                    tp_logradouro,
                    nu_telefone_residencial,
                    nu_telefone_celular,
                    nu_telefone_contato,
                    ds_email,
                    st_ativo_para_exibicao,
                    st_unificado,
                    nu_cpf_responsavel,
                    no_sexo
                FROM
                    tb_cidadao
                WHERE
                    nu_cns = ? OR nu_cpf = ?
                ORDER BY co_seq_cidadao DESC LIMIT 1
            ";
            $rs = $cdb->prepare($sql);
            $rs->bindParam(1,$_SESSION['cns']);
            $rs->bindParam(2,$_SESSION['cpf']);
            if($rs->execute()){
                if($rs->rowCount() <= 0){
                    $sec_deslogar = true;
                    $retorno = "Cidadão não encontrado | ";
                } else {
                    while($row = $rs->fetch(PDO::FETCH_OBJ)){
                        $sec_cid_datanas = $row->dt_nascimento;
                        $sec_cid_sexo = $row->no_sexo;
                    }
                }
            }
        } else {
            $sec_deslogar = true;
            $retorno = " Não foi possível conectar ao e-SUS | ";
        }
    } else {
        $sec_deslogar = true;
        $sec_mensagem .= "Kiosk não encontrado | ";
    }
}

$ctrl_local = md5(date('is').rand(0,9).rand(0,9).rand(0,9).rand(0,9).date('YmdHis'));
if ($_SESSION['ctrl'] == '0'){
    $_SESSION['ctrl'] = $ctrl_local;
}
if ($ctrl_r){
	if ($_SESSION['ctrl'] != $ctrl_local){
		$sec_deslogar = true;
		$sec_mensagem .= "Seção expirou | ";
	}
}

if ($sec_deslogar){
	unset($_SESSION['cpf']);
	unset($_SESSION['cns']);
	unset($_SESSION['nome']);
    unset($_SESSION['co_cidadao']);
    unset($_SESSION['ssl']);
    unset($_SESSION['ssi']);
	$_SESSION = array();
	if (ini_get("session.use_cookies")) {
		$params = session_get_cookie_params();
		setcookie(session_name(), '', time() - 42000,
			$params["path"], $params["domain"],
			$params["secure"], $params["httponly"]
		);
	}
	session_destroy();
	header('location:index.php?tk='.$_SESSION['tk'].'&msg='.$sec_mensagem);
	exit;
}


?>