<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');
include('parametros.php');

$matb = isset($_GET["matb"]) ? trim($_GET["matb"]) : '0';
if ($matb == '0' || $matb == '00' || strlen($matb) <= 0){
	$matb = '';
}

$mostrar = isset($_GET["mostrar"]) ? trim($_GET["mostrar"]) : '';

$dtif = isset($_GET["dtif"]) ? $_GET["dtif"] : 0;
if ($dtif == 0){
	$dti = fgpa('i');
	$dtf = fgpa('f');
} else {
	if (strlen($dtif) == 23){
		$dti = datanas4(trim(substr($dtif,0,10)));
		$dtf = datanas4(trim(substr($dtif,13,10)));	
	} else {
		$dti = fgpa('i');
		$dtf = fgpa('f');
	}

}
$dtif = datanas6($dti).' - '.datanas6($dtf);

$scsus_demo = false;
if (isset($scsus_demonstracao)){
    if ($scsus_demonstracao){
        $scsus_demo = true;
    }
}

$titulo = "";

$cfg_largura = $cfgeral_largura;
$cfg_altura = $cfgeral_altura;
$cfg_latitude = $cfgeral_latitude;
$cfg_longitude = $cfgeral_longitude;
$cfg_zoom = $cfgeral_zoom;
$cfg_tbtmp = $cfgeral_tbtmp;
$cfg_coorintacomp = $cfgeral_coorintacomp;
$cfg_metodo = $cfgeral_metodo;
$cfg_key_api_bing = $cfgeral_key_api_bing;
$masc = '';

$rs = $con->prepare("SELECT * FROM maps_tb_cf_geral WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
			$cfg_largura = $row->largura;
			$cfg_altura = $row->altura;
			$cfg_latitude = $row->latitude;
			$cfg_longitude = $row->longitude;
			$cfg_zoom = $row->zoom;
			$cfg_tbtmp = $row->tbtmp;
			$cfg_coorintacomp = $row->coorintacomp;
			$masc = $row->masc;
			$cfg_metodo = $row->metodo;
			$cfg_key_api_bing = $row->key_api_bing;
		}
	}
}

if ($cfg_metodo == 0 && strlen($cfg_key_api_bing) <= 0){
	$cfg_key_api_bing = $cfgeral_key_api_bing2;
}

$prim_lat = $cfg_latitude;
$prim_lon = $cfg_longitude;
$prim_coord = true;

$invertido = false;
$mascat = array();
if (strlen($masc) > 0){
    if (strlen($masc) == 1 && $masc == '0'){
        $mascat[] = "todos";
    } else {
        if (strlen($masc) >= 2){
            if (substr($masc,0,1) == '-'){
                $invertido = true;
                $masc = substr($masc,1);
            }
            $pos = strpos($masc,';');
            if ($pos === false) {
                if (strlen($masc) == 2){
                    $mascat[] = $masc;
                }
            } else {
                $mascat = explode(';',$masc);
            }
        }
    }
} else {
	$mascat[] = "todos";
}



$matriz_casas = "";
$matriz_casas_ma = "";
$casas_ma = array();
$casas_ma_conta = 0;
$array_cidadao = array();
include($path_local_raiz.'class/_cidadao.class.php');

if (strlen($matb) > 0){

	if ($mostrar == '01'){
		include($path_local_raiz.'class/_gestantes.class.php');
		$orig = new GestantesNV($cdb, $dti, $dtf);
		$orig->todos();
		$array_cidadao = $orig->gestantes;
		$tt_mostra = "Gestantes";
		$tt_icone = "gest1.png";
		$tt_icone_ma = "gest2.png";
	} elseif ($mostrar == '02'){
		$sexo_moh = "FEMININO";
		$idin = 25*12;
		$idfi = 64*12+11;
		$orig = new Cidadaos($cdb, $sexo_moh, $idin, $idfi, $dti, $dtf);
		$orig->todos();
		$array_cidadao = $orig->cidadaos;
		$tt_mostra = "Mulheres";
		$tt_icone = "mulher1.png";
		$tt_icone_ma = "mulher2.png";
	} elseif ($mostrar == '03'){
		$sexo_moh = "T";
		$idin = 12;
		$idfi = 12;
		$orig = new Cidadaos($cdb, $sexo_moh, $idin, $idfi, $dti, $dtf);
		$orig->todos();
		$array_cidadao = $orig->cidadaos;
		$tt_mostra = "Crianças (<=12 meses)";
		$tt_icone = "crian1.png";
		$tt_icone_ma = "crian2.png";
	} elseif ($mostrar == '04'){
		$per_12m = datasomameses($dtf,12,'-');	// 12 últimos meses			
		$dt_6meses1 = datasomadias($per_12m,1); // 12 últimos meses - 6 meses 
		$dt_6meses2 = semestrem($dtf); 			// 6 últimos meses
		$orig = new Cidadaos($cdb, 'T', 0, 150, $per_12m, $dtf, 12);
		$orig->todos();
		$array_cidadao = $orig->cidadaos;
		$tt_mostra = "Hipertensos";
		$tt_icone = "hiper4.png";
		$tt_icone_ma = "hiper5.png";
	} elseif ($mostrar == '05'){
		$per_12m = datasomameses($dtf,12,'-');	// 12 últimos meses			
		$dt_6meses1 = datasomadias($per_12m,1); // 12 últimos meses - 6 meses 
		$dt_6meses2 = semestrem($dtf); 			// 6 últimos meses
		$orig = new Cidadaos($cdb, 'T', 0, 150, $per_12m, $dtf, 12);
		$orig->todos();
		$array_cidadao = $orig->cidadaos;
		$tt_mostra = "Diabéticos";
		$tt_icone = "diab1.png";
		$tt_icone_ma = "diab2.png";
	}

	if (count($array_cidadao) > 0){
		$matriz_casas = "['".$tt_mostra."', '".$matb."', '".$tt_icone."','".$cfg_ma_cor_borda."','".$cfg_ma_cor_fundo."',".$cfg_ma_opacidade.",[";
		$matriz_casas_ma = "['".$tt_mostra." ".$matb."', '".$matb."', '".$tt_icone_ma."','".$cfg_ma_cor_borda."','".$cfg_ma_cor_fundo."',".$cfg_ma_opacidade.",[";
		$conta_casas = 0;
		$conta_casas_ma = 0;
		for ($i=0;$i<count($array_cidadao);$i++){
			/*
			if ($mostrar == '01'){
				$gest_cns = $array_cidadao[$i]['cns'];
				$gest_cpf = $array_cidadao[$i]['cpf'];
				$gest_consuta_1 = $array_cidadao[$i]['con1cDoI'];
				$gest_sexo = $array_cidadao[$i]['sexo'];
				$gest_dpp = $array_cidadao[$i]['dpp'];
				$gest_consuta_i = $array_cidadao[$i]['dtConsI'];
				$gest_consuta_f = $array_cidadao[$i]['dtConsF'];
				$gest_dum = $array_cidadao[$i]['dum_primeiro'];
			}
			*/
			$computar_cidadao = false;
			$cid_marc = '';
			if ($mostrar == '04' || $mostrar = '05'){
				if ($mostrar = '04'){
					$cid_marc = $array_cidadao[$i]['st_hipertensao_arterial'];
					if ($cid_marc == 1){
						$computar_cidadao = true;
					}
				}
				if ($mostrar = '05'){
					$cid_marc = $array_cidadao[$i]['st_diabete'];
					if ($cid_marc == 1){
						$computar_cidadao = true;
					}
				}
			} else {
				$computar_cidadao = true;
			}
			if ($computar_cidadao){
				$fat_cidadao = $array_cidadao[$i]['cidadao'];
				$cid = new CidadaoFAT($cdb, $fat_cidadao);
				if ($cid->ok){
					$cid->dados();
					// BAIXADO +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
					// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
					$cid_baixado = 0;
					$alerta_baixa = "";
					if (substr($cid->motBaixaDs,0,1) != 'N'){
						if (substr($cid->motBaixaDs,0,1) == 'M'){
							$cid_baixado = 1;
						} else {
							if (substr($cid->motBaixaDs,1,1) == 'b'){
								$cid_baixado = 2;
							}
						}
						$alerta_baixa = $cid->motBaixaDs;
					}
					$data_obito = $cid->dtObito;
					if (strlen($data_obito) >= 8){
						$data_obito = datanas2($cid->dtObito);
						$cid_baixado = 2;
						$alerta_baixa = "Óbito pela indicação da data";
					}
					if ($cid->faleceu == 1){
						$cid_baixado = 2;
					}
					// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
					// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

					$casa_endereco = '';
					$cid_uf = '';
					$cid_cidade = '';
					$cid_bairro = '';
					$cid_logradouro = '';
					$cid_numero = '';
					$cid_complemento = '';
					$cid_tipoLogradouro = '';
					$cid_cep = '';
					if (true){
						$ender = new Endereco($cdb, $cid->nome, $cid->mae, $cid->dtNascimento, $cid->cns, $cid->cpf, $cid->cnsResponsavel, $cid->cpfResponsavel);
						if ($ender->ok){
							$lat = $ender->latitude;
							$lon = $ender->longitude;

							$cid_uf = $ender->uf;
							$cid_cidade = $ender->cidade;
							$cid_bairro = $ender->bairro;
							$cid_logradouro = $ender->logradouro;
							$cid_numero = $ender->numero;
							$cid_complemento = $ender->complemento;
							$cid_tipoLogradouro = $ender->tipoLogradouro;
							$cid_cep = $ender->cep;
						}
					}
					$lat = ($lat == 0) ? '' : $lat;
					$lon = ($lon == 0) ? '' : $lon;
					if (strlen($lat) > 0 && strlen($lon) > 0){
						if ($prim_coord){
							$prim_lat = $lat;
							$prim_lon = $lon;
							$prim_coord = false;
						}
					}
					if ($cid_baixado == 0){
						$casa_endereco = $cid_tipoLogradouro.' '.$cid_logradouro.' '.$cid_numero.' '.$cid_cidade.' '.$cid_uf;
						$casa_endereco = tirap($casa_endereco);
						$casa_endereco = strtolower($casa_endereco);
						$pg_cor_internet = false;
						if ((strlen($lat) <= 0 || strlen($lon) <= 0) && $_SESSION['internet'] && $cfg_coorintacomp == 1){
							if ($cfg_metodo == 0 && strlen($cfg_key_api_bing) > 10){
								$mt0_endereco = $cid_uf."/".$cid_cidade."/".$cid_numero." ".$cid_logradouro;
								$mt0_endereco = urlencode($mt0_endereco);
								$mt0_url = "http://dev.virtualearth.net/REST/v1/Locations/BR/".$mt0_endereco."?output=xml&key=".$cfg_key_api_bing;
								$mt0_response = simplexml_load_file($mt0_url);
								$pg_cor_internet = true;
								$lat = $mt0_response->ResourceSets->ResourceSet->Resources->Location->Point->Latitude;
								$lon = $mt0_response->ResourceSets->ResourceSet->Resources->Location->Point->Longitude;
							} else {
								$name_address = urlencode($casa_endereco);
								$baseUrl = 'http://nominatim.openstreetmap.org/search?format=json&q='.$name_address;
								$opts = array(
									'http' => array(
										'header' => "User-Agent:MyAgent/1.0\r\n"
									)
								); 
								$context = stream_context_create($opts);
								$data = @file_get_contents($baseUrl, false, $context);
								if($data === FALSE) { 
									// nao retornou nada
								} else {
									$json = json_decode($data);
									$trouxe_conteudo = true;
									if (empty($json)) {
										$trouxe_conteudo = false;
									}
									if ($trouxe_conteudo){
										$pg_cor_internet = true;
										$lat = $json[0]->lat;
										$lon = $json[0]->lon;
									}
								}
							}
						}
						if ($cid->ma == $matb){
							$ctrl_dup = $cid->nome.$cid->mae.$cid->dtNascimento.$cid_logradouro;
							if (false !== $key = array_search($ctrl_dup, array_column($casas_ma, 'ctrl'))) {
								// encontrou duplicado
							} else {
								$casas_ma[$casas_ma_conta]['lat'] = $lat;
								$casas_ma[$casas_ma_conta]['lon'] = $lon;
								$casas_ma[$casas_ma_conta]['uf'] = $cid_uf;
								$casas_ma[$casas_ma_conta]['municipio'] = $cid_cidade;
								$casas_ma[$casas_ma_conta]['marea'] = $cid->ma;
								$casas_ma[$casas_ma_conta]['bairro'] = $cid_bairro;
								$casas_ma[$casas_ma_conta]['logradouro'] = $cid_logradouro;
								$casas_ma[$casas_ma_conta]['numero'] = $cid_numero;
								$casas_ma[$casas_ma_conta]['pginter'] = $pg_cor_internet;
								$casas_ma[$casas_ma_conta]['complemento'] = $cid_complemento;
								$casas_ma[$casas_ma_conta]['responsavel'] = $cid->nome;
								$casas_ma[$casas_ma_conta]['mae'] = $cid->mae;
								$casas_ma[$casas_ma_conta]['dtnas'] = $cid->dtNascimento;
								$casas_ma[$casas_ma_conta]['endereco'] = $casa_endereco;
								$casas_ma[$casas_ma_conta]['ctrl'] = $ctrl_dup;
								$casas_ma_conta++;
							}
						}
						if (strlen($lat) > 0 && strlen($lon) > 0){
							if ($cid->ma == $matb){
								$matriz_casas_ma .= "[".$lat.", ".$lon.", '<b>".$cid->nome."</b><br>".$cid_tipoLogradouro." ".$cid_logradouro.", ".$cid_numero."<br>".$cid_cep." ".$cid_bairro." (".$cid_complemento.")<br>Microárea: ".$cid->ma."'],";
								$conta_casas_ma++;
							} else {
								$matriz_casas .= "[".$lat.", ".$lon.", '<b>".$cid->nome."</b><br>".$cid_tipoLogradouro." ".$cid_logradouro.", ".$cid_numero."<br>".$cid_cep." ".$cid_bairro." (".$cid_complemento.")<br>Microárea: ".$cid->ma."'],";
								$conta_casas++;
							}
						}
					}
				}
			}
		}
		$matriz_casas .= "]],";
		if ($conta_casas <= 0){
			$matriz_casas = "";
		}
		$matriz_casas_ma .= "]],";
		if ($conta_casas_ma <= 0){
			$matriz_casas_ma = "";
		}
	}
}

$matriz_area = "";
if (strlen($matb) > 0){
	$rs = $con->prepare("SELECT * FROM maps_tb_areas WHERE id = ? AND ibge = ? AND ma = ? AND ativo = 1");
	$rs->bindParam(1,$_SESSION['login']);
	$rs->bindParam(2,$_SESSION['ibge']);
	$rs->bindParam(3,$matb);
	if($rs->execute()){
		if($rs->rowCount() > 0){
			while($row = $rs->fetch(PDO::FETCH_OBJ)){
				$matriz_area .= "['".$row->nome."',".$row->idg.",'".$row->icone."','".$row->cor_borda."','".$row->cor_fundo."',".$row->opacidade.",'".$row->descricao."',[";
				$rsp = $con->prepare("SELECT * FROM maps_tb_areas_pontos WHERE id = ? AND ibge = ? AND klink = ?");
				$rsp->bindParam(1,$_SESSION['login']);
				$rsp->bindParam(2,$_SESSION['ibge']);
				$rsp->bindParam(3,$row->klink);
				if($rsp->execute()){
					if($rsp->rowCount() > 0){
						while($rowp = $rsp->fetch(PDO::FETCH_OBJ)){
							$matriz_area .= "[".$rowp->latitude.",".$rowp->longitude.",'".$rowp->descricao."'],";
						}
					}
				}
				$matriz_area .= "]],";
			}
		}
	}
}

?>
<link rel="stylesheet" type="text/css" href="mod/maps/leaflet/leaflet.css">

<!-- Basic Inputs start -->
<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Acompanhamento</h4>
                </div>
                <div class="card-body mt-2">
                  <p class="card-text">Escolha uma Microárea para ver o mapa</p>
                  <form class="dt_adv_search" name="frm" id="frm" method="POST">




					<div class="row g-1 mb-md-1">
						<div class="col-md-2">
							<label class="form-label"><b>Microárea</b></label>
							<select class="form-select" aria-label="Default select example" name="matb" id="matb">
								<option value="0">Escolha uma Microárea</option>
								<?php
									$ct_equipe = '';
									$domi = $cdb->query($sql_ma);
									if($domi->execute()){
										if($domi->rowCount() > 0){
											while($rowsd = $domi->fetch(PDO::FETCH_OBJ)){
												if ($rowsd->no_equipe != $ct_equipe){
													if (strlen($ct_equipe) > 0){
														echo "</optgroup>";
													}
													$ct_equipe = $rowsd->no_equipe;
													echo "<optgroup label=\"".$rowsd->no_equipe."\">";
												}
												if (in_array("todos", $mascat)) {
													if ($matb == $rowsd->nu_micro_area){
														echo "<option value=\"".$rowsd->nu_micro_area."\" selected>[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
													} else {
														echo "<option value=\"".$rowsd->nu_micro_area."\">[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
													}
												} else {
													if ($invertido){
														if (!in_array($rowsd->nu_micro_area, $mascat)) {
															if ($matb == $rowsd->nu_micro_area){
																echo "<option value=\"".$rowsd->nu_micro_area."\" selected>[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
															} else {
																echo "<option value=\"".$rowsd->nu_micro_area."\">[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
															}	
														}
													} else {
														if (in_array($rowsd->nu_micro_area, $mascat)) {
															if ($matb == $rowsd->nu_micro_area){
																echo "<option value=\"".$rowsd->nu_micro_area."\" selected>[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
															} else {
																echo "<option value=\"".$rowsd->nu_micro_area."\">[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
															}	
														}
													}
												}	
											}
											echo "</optgroup>";
										}
									}
								?>
							</select>
						</div>
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="mb-1">
                                <label class="form-label" for="dtif">Data de Inicio e Data de Fim das visitas</label>
                                <input type="text" class="form-control float-right" name="dtif" id="dtif" />
                            </div>
                        </div>
						<div class="col-md-2">
							<label class="form-label"><b>Mostrar</b></label>
							<select class="form-select" aria-label="Default select example" name="mostrar" id="mostrar">
								<?php
								for($a=0;$a<count($acompanhados);$a++){
									if ($mostrar == $acompanhados[$a]['vl']){
										$titulo = $acompanhados[$a]['show'];
										echo "<option value=\"".$acompanhados[$a]['vl']."\" selected>".$acompanhados[$a]['show']."</option>";
									} else {
										echo "<option value=\"".$acompanhados[$a]['vl']."\">".$acompanhados[$a]['show']."</option>";
									}
								}
								?>

							</select>
						</div>
						<button class="btn btn-warning col-md-4" type="button" id="tbtmpbt">Ver mapa</button>
					</div>




                  </form>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Mapa</h4>
                </div>
                <div class="card-body mt-2">

                  <div id='mapv' style="width: <?php echo $cfg_largura;?>; height: <?php echo $cfg_altura;?>;"></div>

                </div>
            </div>
        </div>
    </div>
</section>
<div id="resendereco" name="resendereco"></div>
<?php
if (strlen($mostrar) > 0){
?>
                <!-- Bordered table start -->
                <div class="row" id="table-bordered">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title"><?php echo $titulo;?> - Microárea <?php echo $matb;?></h4>
                            </div>
                            <div class="card-body">
                                <p class="card-text">
                                    De <?php echo datanas6($dti);?> até <?php echo datanas6($dtf);?>
                                </p>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Bairro</th>
                                            <th>Logradouro</th>
                                            <th>Número</th>
                                            <th>Complemento</th>
                                            <th>Responsável</th>
											<th>Coordenadas</th>
                                        </tr>
                                    </thead>
                                    <tbody>
									<?php
										for($i=0;$i<count($casas_ma);$i++){
											$td_coord = "<td><span class=\"badge rounded-pill badge-light-primary me-1\">".$casas_ma[$i]['lat']." ".$casas_ma[$i]['lon']."</span> ".$casas_ma[$i]['pginter']."<br><a href=\"https://maps.google.com/?q=".$casas_ma[$i]['lat'].",".$casas_ma[$i]['lon']."\" target=\"_blank\">Mapa</a></td>";
											if (strlen($casas_ma[$i]['lat']) <= 0 || strlen($casas_ma[$i]['lon']) <= 0){
												//$td_coord = "<td><span class=\"badge rounded-pill badge-light-danger me-1\">Sem coordenadas</span><button onclick=\"vercoord('".urlencode($casas_ma[$i]['endereco'])."');\"><img src=\"mod/maps/img/mapa.png\"></button></td>";
												$td_coord = "<td><span class=\"badge rounded-pill badge-light-danger me-1\">Sem coordenadas</span><img src=\"mod/maps/img/mapa.png\" onclick=\"vercoord('".urlencode($casas_ma[$i]['endereco'])."');\"></td>";
											}
											echo "
											<tr>
												<td><span class=\"fw-bold\">".$casas_ma[$i]['bairro']."</span></td>
												<td><span class=\"fw-bold\">".$casas_ma[$i]['logradouro']."</span></td>
												<td>".$casas_ma[$i]['numero']."</td>
												<td>".$casas_ma[$i]['complemento']."</td>
												<td>".$casas_ma[$i]['responsavel']."<br>Mãe: ".$casas_ma[$i]['mae']."<br>Dt nas.: ".datanas2($casas_ma[$i]['dtnas'])."</td>
												".$td_coord."
											</tr>
											";
										}
									?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Bordered table end -->
<?php
}
?>


<script src="mod/maps/leaflet/leaflet.js"></script>
<script>

function vercoord(end) {
	var resultado = 'Latitude e longitude não encontrado!';
	$.get(location.protocol + '//nominatim.openstreetmap.org/search?format=json&q=' + end, function(data){
		//alert(JSON.stringify(data));
		//var obj = JSON.parse(data);
		res = JSON.stringify(data);
		resultado = 'ID área: ' + data[0].place_id + '<br>';
		resultado += 'ID OSM: ' + data[0].osm_id + '<br>';
		resultado += 'Latitude: ' + data[0].lat + '<br>';
		resultado += 'Longitude: ' + data[0].lon + '<br>';
		resultado += 'Classe: ' + data[0].class + '<br>';
		resultado += 'Tipo: ' + data[0].type + '<br>';
		resultado += 'Completo: ' + data[0].display_name + '<br>';
		resultado += '<a href="https://maps.google.com/?q=' + data[0].lat + ',' + data[0].lon + '" target="_blank">Mapa</a><br>';
		resultado += 'Área: [' + data[0].boundingbox + ']<br>';
		toastr['success'](
			resultado,
			'Localização geográfica',        
			{
				closeButton: true,
				debug: false,
				newestOnTop: false,
				progressBar: false,
				positionClass: "toast-top-right",
				preventDuplicates: false,
				tapToDismiss: true,
				onclick: null,
				showDuration: "300",
				hideDuration: "1000",
				timeOut: "5000",
				extendedTimeOut: "1000",
				showEasing: "swing",
				hideEasing: "linear",
				showMethod: "fadeIn",
				hideMethod: "fadeOut"
			}
		);
	});
};

$(function () {

  SlickLoader.disable();

  const vLatitude = <?php echo $prim_lat;?>;
  const vLongitude = <?php echo $prim_lon;?>;
  const vZoom = <?php echo $cfg_zoom;?>;

  	let camadas = [
		<?php echo $matriz_casas;?>
		<?php echo $matriz_casas_ma;?>
	];

	let areas = [
		<?php echo $matriz_area;?>
	];

	const mbAttr = 'Map data &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, Imagery © <a href="https://www.mapbox.com/">Mapbox</a>';
	const mbUrl = 'https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoibWFwYm94IiwiYSI6ImNpejY4NXVycTA2emYycXBndHRqcmZ3N3gifQ.rJcFIG214AriISLbB6B5aw';
	const mbAttrOsm = '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>';
	const mbUrlOsm = 'https://tile.openstreetmap.org/{z}/{x}/{y}.png';
	const mbUrlCarto = 'https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png';
	const mbCarto = '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, &copy; <a href="https://carto.com/attribution">CARTO</a>';

	const positron = L.tileLayer(mbUrlCarto, {attribution: mbCarto});
	const streets = L.tileLayer(mbUrl, {id: 'mapbox/streets-v11', tileSize: 512, zoomOffset: -1, attribution: mbAttr});
	const satellite = L.tileLayer(mbUrl, {id: 'mapbox/satellite-v9', tileSize: 512, zoomOffset: -1, attribution: mbAttr});
	const osm = L.tileLayer(mbUrlOsm, {maxZoom: 19, attribution: mbAttrOsm});

	const LeafIcon = L.Icon.extend({
		options: {
			iconSize:     [24, 24],
			iconAnchor:   [22, 94],
			popupAnchor:  [-3, -76]
		}
	});
	const overlays = {};
	let lays = [];
	lays[0] = <?php echo $mapa_abertura;?>;

	let grupo = [];
	let icone = [];
	let itmap = [];
	//let polygon = [];
	var ct_itmap = 0;
	//let pontos_polig = [];
    for(var i = 0; i < camadas.length; i++) {
		grupo[i] = L.layerGroup();
		icone[i] = new LeafIcon({iconUrl: 'mod/maps/img/' + camadas[i][2]});
		overlays[camadas[i][0]] = grupo[i];
		lays[i+1] = grupo[i];
		//pontos_polig = [];
        for(var f = 0; f < camadas[i][6].length; f++) {
			itmap[ct_itmap] = L.marker([camadas[i][6][f][0], camadas[i][6][f][1]], {icon: icone[i]}).bindPopup(camadas[i][6][f][2] + '<br><a href="https://maps.google.com/?q=' + camadas[i][6][f][0] + ',' + camadas[i][6][f][1] + '" target="_blank">Mapa</a><br>' + camadas[i][6][f][0] + ',' + camadas[i][6][f][1]).addTo(grupo[i]);
			ct_itmap++;
			//pontos_polig[f] = [camadas[i][6][f][0], camadas[i][6][f][1]];
        }
		//polygon[i] = L.polygon([pontos_polig],{color: camadas[i][3], fillColor: camadas[i][4], fillOpacity: camadas[i][5]}).bindPopup(camadas[i][0]);
		//overlays['Área: ' + camadas[i][0]] = polygon[i];
    }

	if (typeof areas !== 'undefined') {
		let ipolygon = [];
		var index_layp = lays.length - 1;
		let pontos_polig_areai = [];
		for(var c = 0; c < areas.length; c++) {
			pontos_polig_areai = [];
			for(var f = 0; f < areas[c][7].length; f++) {
				pontos_polig_areai[f] = [areas[c][7][f][0], areas[c][7][f][1]];
			}
			ipolygon[c] = L.polygon([pontos_polig_areai],{color: areas[c][3], fillColor: areas[c][4], fillOpacity: areas[c][5]}).bindPopup(areas[c][0]);
			overlays['Área: ' + areas[c][0]] = ipolygon[c];
			index_layp = index_layp + 1;
			lays[index_layp] = ipolygon[c];
		}
	}



	const baseLayers = {
		'OpenStreetMap': osm,
		'Ruas': streets,
		'Satelite': satellite,
		'Mapa': positron
	};
	const map = L.map('mapv', {
		center: [vLatitude, vLongitude],
		zoom: vZoom,
		layers: lays
	});
	const layerControl = L.control.layers(baseLayers, overlays).addTo(map);

	const popup = L.popup();
	function onMapClick(e) {
    const ta1 = e.latlng.toString().split("(");
    const ta2 = ta1[1].split(",");
    const tLatitude = ta2[0].trim();
    const tLongitude = ta2[1].substring(0,ta2[1].length-1).trim();
		popup
			.setLatLng(e.latlng)
			.setContent('As coordenadas aqui são: ' + tLatitude + ', ' + tLongitude + '<br><a href="https://maps.google.com/?q=' + tLatitude + ',' + tLongitude + '" target="_blank">Mapa</a>')
			.openOn(map);
	}
	map.on('click', onMapClick);

	/*
	$("#btend").click(function() {
		$.get(location.protocol + '//nominatim.openstreetmap.org/search?format=json&q=' + $("#endereco").val(), function(data){
			//alert(JSON.stringify(data));
			//var obj = JSON.parse(data);
			var resultado = 'ID área: ' + data[0].place_id + '<br>';
			resultado += 'ID OSM: ' + data[0].osm_id + '<br>';
			resultado += 'Latitude: ' + data[0].lat + '<br>';
			resultado += 'Longitude: ' + data[0].lon + '<br>';
			resultado += 'Classe: ' + data[0].class + '<br>';
			resultado += 'Tipo: ' + data[0].type + '<br>';
			resultado += 'Completo: ' + data[0].display_name + '<br>';
			resultado += 'Área: ' + data[0].boundingbox + '<br>';
			$("#resendereco").html(resultado);
		});
	});
	*/

	$('#dtif').daterangepicker({
		startDate: '<?php echo datanas6($dti);?>',
		endDate: '<?php echo datanas6($dtf);?>',
		locale: {
			format: 'DD/MM/YYYY'
		}
	});

	$("#tbtmpbt").click(function() {
		SlickLoader.enable();
		$('.content-body').load('mod/maps/acomp.php?matb=' + $("#matb").find(":selected").val() + '&mostrar=' + $('#mostrar').val() + '&dtif=' + encodeURIComponent($('#dtif').val()));
	});





});




</script>