<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');
include('parametros.php');

$klink = isset($_GET["klink"]) ? trim($_GET["klink"]) : '';
$idg = isset($_GET["idg"]) ? trim($_GET["idg"]) : 0;

$lat = 0;
$lon = 0;

if (strlen($klink) > 1 && $idg > 0){
    $rs = $con->prepare("SELECT * FROM maps_tb_areas_pontos WHERE id = ? AND ibge = ? AND klink = ? AND idg = ? LIMIT 1");
    $rs->bindParam(1,$_SESSION['login']);
    $rs->bindParam(2,$_SESSION['ibge']);
    $rs->bindParam(3,$klink);
    $rs->bindParam(4,$idg);
    if($rs->execute()){
        if($rs->rowCount() > 0){
            while($row = $rs->fetch(PDO::FETCH_OBJ)){
                $lat = $row->latitude;
                $lon = $row->longitude;
            }
        }
    }
}

?>

<form class="dt_adv_search" name="frm-area" id="frm-area" method="POST">
    <input type="hidden" id="klink" name="klink" value="<?php echo $klink;?>">
    <input type="hidden" id="idg" name="idg" value="<?php echo $idg;?>">
    <label>Latitude: </label>
    <div class="mb-1">
        <input type="number" name="latitude" id="latitude" class="form-control" value="<?php echo $lat;?>" />
    </div>
    <label>Longitude: </label>
    <div class="mb-1">
        <input type="number" name="longitude" id="longitude" class="form-control" value="<?php echo $lon;?>" />
    </div>
    <button type="submit" class="btn btn-primary">Gravar</button>
</form>

<script>
$(function () {
  $('#frm-area').validate({
    submitHandler: function (form) {
        $.post('mod/maps/gv_ed_area_ponto.php', $('#frm-area').serialize(), function (data, textStatus) {
            if (data == 'Ok'){ // data.substring(0,2)
                swal.fire('Ok!','Gravado com sucesso!','success');
            } else {
                swal.fire('erro!',data,'error');
            }
        });
    },
    rules: {
        latitude: {
          required: true,
          number:true
        },
        longitude: {
          required: true,
          number:true
        },
    },
    messages: {
        latitude: {
          required: "Este campo é necessário",
          number: "Deve ser número"
        },
        longitude: {
          required: "Este campo é necessário",
          number: "Deve ser número"
        },
    }
  });
})
</script>